from qgis.core import Qgis, QgsMessageLog


def renderWarning(message, qgisInterface, title="RimoPrinting"):
    """Pushes a warning message to the log panel and pops up in the message bar.
    :param message: Warning message
    :type message: String

    :param title: title of the warning message
    :type title: String
    """
    qgisInterface.messageBar().clearWidgets()
    if Qgis.QGIS_VERSION_INT < 32000:
        qgisInterface.messageBar().pushMessage(
            text=message, title=title, level=Qgis.Warning
        )
        QgsMessageLog.logMessage(message=message, tag=title, level=Qgis.Warning)
    else:
        qgisInterface.messageBar().pushMessage(
            text=message, title=title, level=Qgis.MessageLevel.Warning
        )
        QgsMessageLog.logMessage(
            message=message, tag=title, level=Qgis.MessageLevel.Warning
        )


def renderInfo(message, qgisInterface, title="RimoPrinting"):
    """Pushes a info message to the log panel and pops up in the message bar.
    :param message: Info message
    :type message: String

    :param title: title of the info message
    :type title: String
    """
    qgisInterface.messageBar().clearWidgets()
    if Qgis.QGIS_VERSION_INT < 32000:
        qgisInterface.messageBar().pushMessage(
            text=message, title=title, level=Qgis.Info
        )
        QgsMessageLog.logMessage(message=message, tag=title, level=Qgis.Info)
    else:
        qgisInterface.messageBar().pushMessage(
            text=message, title=title, level=Qgis.MessageLevel.Info
        )
        QgsMessageLog.logMessage(
            message=message, tag=title, level=Qgis.MessageLevel.Info
        )
