from typing import List


class Tenant:
    def __init__(self, oop: str, nameToDisplay: str, id: str):
        self.nameToDisplay = nameToDisplay
        self.oop = oop
        self.id = id


class UserProfile:
    def __init__(self, oop: str, tenant: Tenant):
        self.oop = oop
        self.tenant = tenant


class SessionState:
    def __init__(self):
        self.loginStatus = False
        self.token = ""
        self.userProfiles: List[UserProfile] = []
        self.tenantOop = ""
        self.tenantId = ""
        self.userOop = ""

    def isLoggedIn(self):
        return self.loginStatus

    def getTenantIds(self):
        return [userProfile.tenant.id for userProfile in self.userProfiles]

    def getAvailableTenants(self):
        return [userProfile.tenant for userProfile in self.userProfiles]

    def setPossibleUserProfiles(self, userProfiles: List[UserProfile]):
        self.userProfiles = userProfiles

    def getTenantById(self, tenantId):
        for availableTenant in self.getAvailableTenants():
            if availableTenant.id == tenantId:
                return availableTenant

    def setTenant(self, tenant: Tenant):
        self.tenantOop = tenant.oop
        self.tenantId = tenant.id
        self.userOop = [
            userProfile
            for userProfile in self.userProfiles
            if userProfile.tenant.oop == tenant.oop
        ][0].oop
