import csv
import os.path
import urllib.parse

from LayerType import LayerType
from qgis.core import QgsVectorLayer

from Helper import removeLongPathPrefixFromPath
from LayerMetadataHelper import LayerMetadataHelper

REVISION_FILE_NAME = "revision.csv"


def createRevisionCSV(clusterDirPath: str):
    csvFile = os.path.join(clusterDirPath, REVISION_FILE_NAME)
    if not os.path.exists(csvFile):
        with open(csvFile, "w") as csvfile:
            fieldnames = ["Revision:", "Bearbeiter:", "Kommentar:"]
            writer = csv.writer(
                csvfile,
                delimiter=";",
                lineterminator="\n",
                quotechar='"',
                quoting=csv.QUOTE_MINIMAL,
            )
            writer.writerow(fieldnames)
            row1 = ["1", "", ""]
            writer.writerow(row1)
    createRevisionCSVT(clusterDirPath)


def createRevisionCSVT(clusterDirPath: str):
    csvtFile = os.path.join(clusterDirPath, REVISION_FILE_NAME.replace(".csv", ".csvt"))
    if not os.path.exists(csvtFile):
        with open(csvtFile, "w") as f:
            f.write('"String","String","String"\n')


def upsertRevisionCSVLayer(qgisProject, clusterDirPath: str):
    """Upsert the Revision CSV layer: remove if exists, then add so .csvt is applied."""
    for layer in list(qgisProject.mapLayers().values()):
        if layer.name() == "Revision":
            qgisProject.removeMapLayer(layer.id())

    """CSV file path notation needed to be file:///path?csvOptions otherwise the vector layer is invalid"""
    csvFilePath = os.path.join(
        removeLongPathPrefixFromPath(clusterDirPath), REVISION_FILE_NAME
    )

    csvOptions = "type=csv&delimiter=;&geomType=none&trimFields=yes&skipEmptyFields=yes"
    csvUri = f"file:///{urllib.parse.quote(csvFilePath)}?{csvOptions}"

    csvLayer = QgsVectorLayer(csvUri, "Revision", "delimitedtext")
    LayerMetadataHelper.setMetadata(csvLayer, LayerType.RIMO_LAYER, "revision")
    qgisProject.addMapLayer(csvLayer, True)
