from typing import Generic, TypeVar

T = TypeVar("T")


class Result(Generic[T]):
    def __init__(self, success: bool, value: T = None, message: str = ""):
        self.success = success
        self.value = value
        self.message = message

    # TODO: Function type parameter syntax requires Python 3.12 or newer
    @staticmethod
    def ok(value: T) -> "Result[T]":
        return Result[T](success=True, value=value)

    @staticmethod
    def fail(message: str = "") -> "Result[T]":
        return Result[T](success=False, message=message)

    def isSuccess(self) -> bool:
        return self.success

    def isFailure(self) -> bool:
        return not self.success
