from ProjectState import ProjectState

PROJECTSTATE_ENVIRONMENT = "environment"
PROJECTSTATE_REGIONNAME = "regionName"
PROJECTSTATE_CLUSTERNAME = "clusterName"
PROJECTSTATE_SITECLUSTERNAME = "siteClusterName"
# called layerSettingName 18.04. layerStyleSetting has to remain
PROJECTSTATE_LAYERSETTINGNAME = "layerStyleSetting"
PROJECTSTATE_CURRENTSTYLING = "currentStyling"
PROJECTSTATE_TENANTNAME = "tenantName"
PROJECTSTATE_OVERRULINGSTYLEFOLDERPATH = "overrulingStyleFolderPath"

PROJECTSTATE_KEYNAME = "rP"


class ProjectStateRepository:
    @staticmethod
    def loadProjectState(qgisProject):
        environment = qgisProject.readEntry(
            PROJECTSTATE_KEYNAME, PROJECTSTATE_ENVIRONMENT, "Production"
        )[0]

        regionName = qgisProject.readEntry(
            PROJECTSTATE_KEYNAME, PROJECTSTATE_REGIONNAME
        )[0]

        clusterName = qgisProject.readEntry(
            PROJECTSTATE_KEYNAME, PROJECTSTATE_CLUSTERNAME
        )[0]

        siteClusterName = qgisProject.readEntry(
            PROJECTSTATE_KEYNAME, PROJECTSTATE_SITECLUSTERNAME
        )[0]

        # called layerSetting 18.04. layerStyleSetting has to remain
        layerSettingName = qgisProject.readEntry(
            PROJECTSTATE_KEYNAME, PROJECTSTATE_LAYERSETTINGNAME
        )[0]

        currentStyling = qgisProject.readEntry(
            PROJECTSTATE_KEYNAME, PROJECTSTATE_CURRENTSTYLING
        )[0]

        tenant = qgisProject.readEntry(PROJECTSTATE_KEYNAME, PROJECTSTATE_TENANTNAME)[0]

        overrulingStyleFolderPath = qgisProject.readEntry(
            PROJECTSTATE_KEYNAME, PROJECTSTATE_OVERRULINGSTYLEFOLDERPATH
        )[0]

        return ProjectState(
            environment,
            regionName,
            clusterName,
            siteClusterName,
            layerSettingName,
            currentStyling,
            tenant,
            overrulingStyleFolderPath,
        )

    @staticmethod
    def saveProjectState(qgisProject, projectState: ProjectState):
        qgisProject.writeEntry(
            PROJECTSTATE_KEYNAME, PROJECTSTATE_ENVIRONMENT, projectState.environment
        )

        qgisProject.writeEntry(
            PROJECTSTATE_KEYNAME, PROJECTSTATE_REGIONNAME, projectState.regionName
        )

        qgisProject.writeEntry(
            PROJECTSTATE_KEYNAME, PROJECTSTATE_CLUSTERNAME, projectState.clusterName
        )

        qgisProject.writeEntry(
            PROJECTSTATE_KEYNAME,
            PROJECTSTATE_SITECLUSTERNAME,
            projectState.siteClusterName,
        )

        # called layerSetting 18.04. layerStyleSetting has to remain
        qgisProject.writeEntry(
            PROJECTSTATE_KEYNAME,
            PROJECTSTATE_LAYERSETTINGNAME,
            projectState.layerSettingName,
        )

        qgisProject.writeEntry(
            PROJECTSTATE_KEYNAME,
            PROJECTSTATE_CURRENTSTYLING,
            projectState.currentStyling,
        )

        qgisProject.writeEntry(
            PROJECTSTATE_KEYNAME, PROJECTSTATE_TENANTNAME, projectState.tenant
        )

        qgisProject.writeEntry(
            PROJECTSTATE_KEYNAME,
            PROJECTSTATE_OVERRULINGSTYLEFOLDERPATH,
            projectState.overrulingStyleFolderPath,
        )
