from ProjectHelper import createProjectName

DEFAULT_STYLE_NAME = "default"


class ProjectState:
    def __init__(
        self,
        environment="Production",
        regionName="",
        clusterName="",
        siteClusterName="",
        layerSettingName="",
        currentStyling=DEFAULT_STYLE_NAME,
        tenant="",
        overrulingStyleFolderPath="",
    ):
        self.environment = environment
        self.regionName = regionName
        self.clusterName = clusterName
        self.siteClusterName = siteClusterName
        self.layerSettingName = layerSettingName
        # the style folder name inside the style folder path --> represents the selected style
        self.currentStyling = currentStyling
        self.tenant = tenant
        self.overrulingStyleFolderPath = overrulingStyleFolderPath

    def getProjectName(self):
        return createProjectName(self.clusterName, self.siteClusterName, self.isDev())

    def isDev(self):
        return self.environment == "Development"

    def copy(self):
        return ProjectState(
            self.environment,
            self.regionName,
            self.clusterName,
            self.siteClusterName,
            self.layerSettingName,
            self.currentStyling,
            self.tenant,
            self.overrulingStyleFolderPath,
        )
