import os

from Helper import cleanName
from Result import Result


def createProjectName(clusterName: str, siteClusterName: str, isDev: bool):
    cluster = cleanName(clusterName)
    subCluster = cleanName(siteClusterName)

    fullClustername = f"{cluster}_{subCluster}"
    fullClusternameShortened = cleanName(fullClustername[:70])

    return (
        f"Development_{fullClusternameShortened}" if isDev else fullClusternameShortened
    )


def getExistingProjectFilePath(projectDirPath: str, projectName: str) -> Result[str]:
    qgsPath = os.path.join(projectDirPath, f"{projectName}.qgs")
    qgzPath = os.path.join(projectDirPath, f"{projectName}.qgz")

    if os.path.exists(qgzPath):
        return Result.ok(qgzPath)
    elif os.path.exists(qgsPath):
        return Result.ok(qgsPath)

    return Result.fail(
        f"Neither a qgs or qgz file could be found for project with name {projectName} and path {projectDirPath}"
    )


def createProjectFilePath(projectDirPath: str, projectName: str, isZipped: bool):
    return (
        os.path.join(projectDirPath, f"{projectName}.qgz")
        if isZipped
        else os.path.join(projectDirPath, f"{projectName}.qgs")
    )
