import json
import logging
from LayerType import LayerType
from Result import Result


class LayerMetadataHelper:
    METADATA_KEY = "rimo_layer_metadata"

    @staticmethod
    def getMetadata(layer):
        try:
            metadataKeywords = layer.metadata().keywords(
                LayerMetadataHelper.METADATA_KEY
            )

            # Since the keywords are interpreted as list and not JSON-string, we need to fix it by joining the keywords
            # again with a semicolon
            if metadataKeywords:
                if isinstance(metadataKeywords, str):
                    return json.loads(metadataKeywords)
                elif isinstance(metadataKeywords, list):

                    if len(metadataKeywords) > 0:
                        json_str = ",".join(metadataKeywords)
                    else:
                        json_str = metadataKeywords[0]

                    return json.loads(json_str)

            keywords = layer.keywordList()
            if keywords and len(keywords) > 0:
                return json.loads(keywords)

            return {"type": LayerType.NONE_LAYER, "name": "Unknown Layer"}
        except Exception as e:
            logging.error(e)
            raise e

    @staticmethod
    def setMetadata(layer, layerType: LayerType, layerName):
        metadata = layer.metadata()
        metadata.addKeywords(
            LayerMetadataHelper.METADATA_KEY,
            [
                json.dumps({"type": layerType.value, "name": layerName}),
            ],
        )
        layer.setMetadata(metadata)

    @staticmethod
    def getType(layer):
        return LayerMetadataHelper.getMetadata(layer).get("type")

    @staticmethod
    def getName(layer):
        return LayerMetadataHelper.getMetadata(layer).get("name")

    @staticmethod
    def tryMigrateKeywords(layers):
        for layer in layers:
            try:
                metadataKeywords = layer.metadata().keywords(
                    LayerMetadataHelper.METADATA_KEY
                )
                if metadataKeywords and len(metadataKeywords) > 0:
                    continue

                keywords = layer.keywordList()
                if keywords and len(keywords) > 0:
                    data = json.loads(keywords)
                    layerType = data.get("type")
                    layerName = data.get("name")
                    if layerType and layerName:
                        try:
                            formattedLayerType = LayerType(layerType)
                        except:
                            return Result.fail(
                                f"Failed to migrate keywordList. Unknown LayerType: {layerType.value}"
                            )

                        LayerMetadataHelper.setMetadata(
                            layer, formattedLayerType, layerName
                        )
            except Exception as e:
                logging.error(e)
                return Result.fail(f"Failed to migrate keywordList.")

        return Result.ok(None)
