import re


def upsertToken(inputUrl, newToken):
    if "|" in inputUrl:
        url_parts = inputUrl.split("|")
        base_url = url_parts[0]
        filters = "|" + url_parts[1]
    else:
        base_url = inputUrl
        filters = ""

    if "token=" in base_url:
        new_url = re.sub(r"(token=)[^&]+", f"token={newToken}", base_url)
    else:
        if "?" in base_url:
            new_url = f"{base_url}&token={newToken}"
        else:
            new_url = f"{base_url}?token={newToken}"

    return new_url + filters
