import glob
import os
import platform
import re


def cleanName(name: str):
    """Deletes als not wanted characters and strips all defined spacing characters (whitspace, -, _) from the input name."""
    # Replace unwanted chars in cluster names
    unwantedChars = [
        ".",
        ",",
        ":",
        ";",
        "%",
        "*",
        "<",
        ">",
        "?",
        "/",
        "\\",
        '"',
        "|",
        "{",
        "}",
        "~",
        "#",
    ]
    for char in unwantedChars:
        name = name.replace(char, "_")

    # Remove replace multiple whitespaces and _ in string
    name = re.sub(r"\s+", " ", name)
    name = re.sub(r"_+\s*_*", "_", name)

    # Remove leading/trailing _ or whitespaces
    name.strip()
    reg_exp = re.compile(r"_+\s*")
    unmodified_length = len(name)
    for match in reg_exp.finditer(name):
        match_start = match.span()[0]
        match_end = match.span()[1]
        if match_start == 0:
            name = name[match_end:]
        elif match_end == unmodified_length:
            name = name[: len(name) - (match_end - match_start)]
    name.strip()

    return name


def getPlatformPath(path: str):
    # String format which uses long path option of windows
    # needed due to buggy implemenation or no support of python libs for long windows paths
    path = os.path.normpath(path)

    if platform.system() == "Windows":
        return str("\\\\?\\{}".format(os.fsdecode(path)))

    return path


def removeLongPathPrefixFromPath(path: str):
    return path.replace("\\\\?\\", "")


def readFileAndFindText(filePath: str, textToFind: str):
    with open(filePath, "r") as in_file:
        for line in in_file:
            if textToFind in line:
                return line


def resolvePath(absoluteBasePath, path) -> str:
    if os.path.isabs(path):
        return os.path.normpath(path)

    return os.path.normpath(os.path.join(absoluteBasePath, path))


def containsFileWithExtension(directoryPath, extension: str):
    qml_files = glob.glob(os.path.join(directoryPath, f"*.{extension}"))

    return len(qml_files) > 0
