from typing import Dict, List

from ProjectState import ProjectState

SITE_CLUSTER_DEFAULT = "Whole Cluster"


class BaseCluster:
    def __init__(self, oop: str, nameToDisplay: str):
        self.oop = oop
        self.nameToDisplay = nameToDisplay


class Region(BaseCluster):
    def __init__(self, oop: str, nameToDisplay: str):
        super().__init__(oop, nameToDisplay)


class Cluster(BaseCluster):
    def __init__(self, oop: str, nameToDisplay: str):
        super().__init__(oop, nameToDisplay)


class SiteCluster(BaseCluster):
    def __init__(self, oop: str, nameToDisplay: str):
        super().__init__(oop, nameToDisplay)


class GisDataState:
    def __init__(self):
        self._regions: List[Region] = []
        self._clusters: List[Cluster] = []
        self._siteClusters: List[SiteCluster] = []

    def hasSiteClusterData(self):
        return len(self._siteClusters) > 0

    def hasClusterData(self):
        return len(self._clusters) > 0

    def getRegionData(self):
        return self._regions

    def setRegionData(self, regions: List[Region]):
        self._regions = regions

        self._clusters = []
        self._siteClusters = []

    def getRegionNames(self) -> List[str]:
        return [region.nameToDisplay for region in self._regions]

    def getRegionByName(self, regionName: str):
        for region in self._regions:
            if region.nameToDisplay == regionName:
                return region

    def getOopForRegionWithName(self, regionName):
        for region in self._regions:
            if region.nameToDisplay == regionName:
                return region.oop

    def getClusters(self):
        return self._clusters

    def setClusters(self, clusters: List[Cluster]):
        self._clusters = clusters

        self._siteClusters = []

    def getClusterNames(self) -> List[str]:
        return [cluster.nameToDisplay for cluster in self._clusters]

    def getClusterByName(self, clusterName: str):
        for cluster in self._clusters:
            if cluster.nameToDisplay == clusterName:
                return cluster

    def getSiteClusters(self):
        return self._siteClusters

    def setSiteClusters(self, siteClusters: List[SiteCluster]):
        self._siteClusters = siteClusters

    def getSiteClusterNames(self) -> List[str]:
        return [siteCluster.nameToDisplay for siteCluster in self._siteClusters]

    def getOopForClusterWithName(self, projectState: ProjectState):
        if projectState.siteClusterName == SITE_CLUSTER_DEFAULT:
            for cluster in self._clusters:
                if cluster.nameToDisplay == projectState.clusterName:
                    return cluster.oop
        else:
            for cluster in self._siteClusters:
                if cluster.nameToDisplay == projectState.siteClusterName:
                    return cluster.oop

    def getSiteClusterByName(self, siteClusterName: str):
        for siteCluster in self._siteClusters:
            if siteCluster.nameToDisplay == siteClusterName:
                return siteCluster
